<?php
// Script para atualizar a senha do admin para 123456

$nova_senha = '123456';
$novo_hash = password_hash($nova_senha, PASSWORD_BCRYPT);

echo "<h2>Atualizando Senha do Admin</h2>";
echo "<p><strong>Nova senha:</strong> $nova_senha</p>";
echo "<p><strong>Novo hash:</strong> $novo_hash</p>";

try {
    require_once 'config/database.php';
    $db = new Database();
    $conn = $db->connect();
    
    // Verificar se admin existe
    $stmt = $conn->prepare("SELECT * FROM administradores WHERE email = ?");
    $stmt->execute(['admin@rideshare.com']);
    $admin = $stmt->fetch();
    
    if ($admin) {
        echo "<p>✓ Admin encontrado: " . $admin['nome'] . "</p>";
        
        // Atualizar senha
        $stmt = $conn->prepare("UPDATE administradores SET senha = ? WHERE email = ?");
        if ($stmt->execute([$novo_hash, 'admin@rideshare.com'])) {
            echo "<p style='color: green;'>✅ Senha atualizada com sucesso!</p>";
            
            // Testar nova senha
            $stmt = $conn->prepare("SELECT senha FROM administradores WHERE email = ?");
            $stmt->execute(['admin@rideshare.com']);
            $result = $stmt->fetch();
            
            if (password_verify($nova_senha, $result['senha'])) {
                echo "<p style='color: green;'>✅ Verificação: Nova senha está funcionando!</p>";
            } else {
                echo "<p style='color: red;'>❌ Erro: Nova senha não está funcionando!</p>";
            }
            
        } else {
            echo "<p style='color: red;'>❌ Erro ao atualizar senha!</p>";
        }
        
    } else {
        echo "<p style='color: orange;'>⚠️ Admin não encontrado. Criando novo admin...</p>";
        
        $stmt = $conn->prepare("INSERT INTO administradores (nome, email, senha, nivel, ativo) VALUES (?, ?, ?, ?, ?)");
        if ($stmt->execute(['Administrador', 'admin@rideshare.com', $novo_hash, 'super', 1])) {
            echo "<p style='color: green;'>✅ Admin criado com sucesso!</p>";
        } else {
            echo "<p style='color: red;'>❌ Erro ao criar admin!</p>";
        }
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Erro: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>Novas Credenciais:</h3>";
echo "<p><strong>Email:</strong> admin@rideshare.com</p>";
echo "<p><strong>Senha:</strong> 123456</p>";
echo "<p><a href='admin/index.html'>🔗 Ir para o Painel Admin</a></p>";
?>