<?php
// Teste simples de senha
$senha = '123456';
$hash_antigo = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi';

echo "<h2>Teste de Senha</h2>";
echo "<p><strong>Senha:</strong> $senha</p>";
echo "<p><strong>Hash antigo:</strong> $hash_antigo</p>";

// Gerar novo hash
$novo_hash = password_hash($senha, PASSWORD_BCRYPT);
echo "<p><strong>Novo hash:</strong> $novo_hash</p>";

// Testar hash antigo
$valido_antigo = password_verify($senha, $hash_antigo);
echo "<p><strong>Hash antigo válido:</strong> " . ($valido_antigo ? 'SIM' : 'NÃO') . "</p>";

// Testar novo hash
$valido_novo = password_verify($senha, $novo_hash);
echo "<p><strong>Novo hash válido:</strong> " . ($valido_novo ? 'SIM' : 'NÃO') . "</p>";

// Teste de conexão
echo "<hr><h3>Teste de Banco</h3>";
try {
    require_once 'config/database.php';
    $db = new Database();
    $conn = $db->connect();
    echo "<p>✓ Conexão OK</p>";
    
    // Verificar tabela administradores
    $stmt = $conn->query("SHOW TABLES LIKE 'administradores'");
    if ($stmt->rowCount() > 0) {
        echo "<p>✓ Tabela administradores existe</p>";
        
        // Contar admins
        $stmt = $conn->query("SELECT COUNT(*) as total FROM administradores");
        $result = $stmt->fetch();
        echo "<p>Total de admins: " . $result['total'] . "</p>";
        
        // Buscar admin específico
        $stmt = $conn->prepare("SELECT * FROM administradores WHERE email = ?");
        $stmt->execute(['admin@rideshare.com']);
        $admin = $stmt->fetch();
        
        if ($admin) {
            echo "<p>✓ Admin encontrado:</p>";
            echo "<ul>";
            echo "<li>ID: " . $admin['id'] . "</li>";
            echo "<li>Nome: " . $admin['nome'] . "</li>";
            echo "<li>Email: " . $admin['email'] . "</li>";
            echo "<li>Ativo: " . ($admin['ativo'] ? 'SIM' : 'NÃO') . "</li>";
            echo "<li>Hash: " . substr($admin['senha'], 0, 30) . "...</li>";
            echo "</ul>";
            
            $senha_valida = password_verify('admin123', $admin['senha']);
            echo "<p><strong>Senha válida:</strong> " . ($senha_valida ? 'SIM' : 'NÃO') . "</p>";
            
            if (!$senha_valida) {
                echo "<p style='color: red;'>❌ PROBLEMA: A senha não confere!</p>";
                echo "<p>Executando correção...</p>";
                
                $stmt = $conn->prepare("UPDATE administradores SET senha = ? WHERE email = ?");
                if ($stmt->execute([$novo_hash, 'admin@rideshare.com'])) {
                    echo "<p style='color: green;'>✓ Senha corrigida!</p>";
                } else {
                    echo "<p style='color: red;'>❌ Erro ao corrigir senha</p>";
                }
            } else {
                echo "<p style='color: green;'>✓ Senha está correta!</p>";
            }
            
        } else {
            echo "<p style='color: red;'>❌ Admin não encontrado!</p>";
            echo "<p>Criando admin...</p>";
            
            $stmt = $conn->prepare("INSERT INTO administradores (nome, email, senha, nivel, ativo) VALUES (?, ?, ?, ?, ?)");
            if ($stmt->execute(['Administrador', 'admin@rideshare.com', $novo_hash, 'super', 1])) {
                echo "<p style='color: green;'>✓ Admin criado!</p>";
            } else {
                echo "<p style='color: red;'>❌ Erro ao criar admin</p>";
            }
        }
        
    } else {
        echo "<p style='color: red;'>❌ Tabela administradores não existe!</p>";
        echo "<p>Execute o arquivo database/schema.sql primeiro</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Erro: " . $e->getMessage() . "</p>";
}
?>