<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

echo "=== TESTE DA API DE MOTORISTAS ===\n\n";

// Verificar se os arquivos necessários existem
$files = [
    'config/database.php',
    'includes/functions.php',
    'api/motoristas.php'
];

foreach ($files as $file) {
    if (file_exists($file)) {
        echo "✅ $file - OK\n";
    } else {
        echo "❌ $file - FALTANDO\n";
    }
}

echo "\n=== TESTANDO CONEXÃO COM BANCO ===\n";

try {
    require_once 'config/database.php';
    $db = new Database();
    $conn = $db->connect();
    echo "✅ Conexão com banco - OK\n";
    
    // Testar se a tabela motoristas existe
    $stmt = $conn->query("SHOW TABLES LIKE 'motoristas'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Tabela motoristas - OK\n";
        
        // Verificar se existe o motorista de teste
        $stmt = $conn->prepare("SELECT id, nome, email, status FROM motoristas WHERE email = ?");
        $stmt->execute(['andre.rj.tj@gmail.com']);
        $motorista = $stmt->fetch();
        
        if ($motorista) {
            echo "✅ Motorista de teste encontrado:\n";
            echo "   ID: {$motorista['id']}\n";
            echo "   Nome: {$motorista['nome']}\n";
            echo "   Email: {$motorista['email']}\n";
            echo "   Status: {$motorista['status']}\n";
        } else {
            echo "❌ Motorista de teste não encontrado\n";
        }
    } else {
        echo "❌ Tabela motoristas - FALTANDO\n";
    }
    
} catch (Exception $e) {
    echo "❌ Erro na conexão: " . $e->getMessage() . "\n";
}

echo "\n=== TESTANDO INCLUDES ===\n";

try {
    require_once 'includes/functions.php';
    echo "✅ functions.php - OK\n";
    
    if (function_exists('jsonResponse')) {
        echo "✅ Função jsonResponse - OK\n";
    } else {
        echo "❌ Função jsonResponse - FALTANDO\n";
    }
    
    if (function_exists('registrarLog')) {
        echo "✅ Função registrarLog - OK\n";
    } else {
        echo "❌ Função registrarLog - FALTANDO\n";
    }
    
} catch (Exception $e) {
    echo "❌ Erro ao carregar functions.php: " . $e->getMessage() . "\n";
}

echo "\n=== SIMULANDO REQUISIÇÃO ===\n";

// Simular uma requisição POST para alterar disponibilidade
$_SERVER['REQUEST_METHOD'] = 'POST';
$input = [
    'action' => 'alterar_disponibilidade',
    'motorista_id' => '1', // ID de teste
    'disponivel' => true
];

echo "Dados da requisição:\n";
echo json_encode($input, JSON_PRETTY_PRINT) . "\n\n";

// Capturar output da API
ob_start();
$_POST = $input;
file_put_contents('php://input', json_encode($input));

try {
    include 'api/motoristas.php';
} catch (Exception $e) {
    echo "❌ Erro na API: " . $e->getMessage() . "\n";
}

$output = ob_get_clean();
echo "Resposta da API:\n$output\n";

echo "\n=== FIM DO TESTE ===\n";
?>