<?php
// Teste de hash de senha
$senha = 'admin123';
$hash_banco = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi';

echo "Senha: " . $senha . "\n";
echo "Hash do banco: " . $hash_banco . "\n";
echo "Novo hash: " . password_hash($senha, PASSWORD_BCRYPT) . "\n";
echo "Verificação: " . (password_verify($senha, $hash_banco) ? 'VÁLIDA' : 'INVÁLIDA') . "\n";

// Teste de conexão com banco
try {
    require_once 'config/database.php';
    $db = new Database();
    $conn = $db->connect();
    echo "Conexão com banco: OK\n";
    
    // Verificar se admin existe
    $stmt = $conn->prepare("SELECT * FROM administradores WHERE email = ?");
    $stmt->execute(['admin@rideshare.com']);
    $admin = $stmt->fetch();
    
    if ($admin) {
        echo "Admin encontrado: " . $admin['nome'] . "\n";
        echo "Email: " . $admin['email'] . "\n";
        echo "Hash no banco: " . $admin['senha'] . "\n";
        echo "Verificação senha: " . (password_verify('admin123', $admin['senha']) ? 'VÁLIDA' : 'INVÁLIDA') . "\n";
    } else {
        echo "Admin não encontrado no banco!\n";
    }
    
} catch (Exception $e) {
    echo "Erro: " . $e->getMessage() . "\n";
}
?>