<?php
header('Content-Type: text/html; charset=utf-8');

echo "<h2>Teste da API de Motoristas</h2>";

// Simular uma requisição POST
$_SERVER['REQUEST_METHOD'] = 'POST';

// Dados de teste
$test_data = [
    'action' => 'alterar_disponibilidade',
    'motorista_id' => '1',
    'disponivel' => true
];

echo "<h3>Dados de teste:</h3>";
echo "<pre>" . json_encode($test_data, JSON_PRETTY_PRINT) . "</pre>";

// Capturar a saída da API
ob_start();

// Simular input JSON
file_put_contents('php://temp', json_encode($test_data));

try {
    // Incluir a API
    include 'api/motoristas.php';
    $output = ob_get_clean();
    
    echo "<h3>Resposta da API:</h3>";
    echo "<pre>$output</pre>";
    
    // Tentar decodificar como JSON
    $json = json_decode($output, true);
    if ($json) {
        echo "<h3>JSON decodificado:</h3>";
        echo "<pre>" . print_r($json, true) . "</pre>";
    }
    
} catch (Exception $e) {
    ob_end_clean();
    echo "<h3>❌ Erro na API:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>Teste direto da função:</h3>";

try {
    require_once 'config/database.php';
    require_once 'includes/functions.php';
    
    $db = new Database();
    $conn = $db->connect();
    
    // Testar update direto
    $stmt = $conn->prepare("UPDATE motoristas SET disponivel = ? WHERE id = ?");
    $result = $stmt->execute([1, 1]);
    
    if ($result) {
        echo "✅ Update direto funcionou<br>";
        echo "Linhas afetadas: " . $stmt->rowCount() . "<br>";
    } else {
        echo "❌ Update direto falhou<br>";
    }
    
} catch (Exception $e) {
    echo "❌ Erro no teste direto: " . $e->getMessage() . "<br>";
}
?>