import React from 'react';
import { User, Power, Search } from 'lucide-react';

const ColorTest = () => {
  return (
    <div className="p-8 bg-gray-100 min-h-screen">
      <h1 className="text-2xl font-bold mb-6">Teste de Cores - RideShare</h1>
      
      {/* Header Test */}
      <div className="bg-white p-4 rounded-xl shadow-md mb-6">
        <div className="flex items-center gap-4">
          <div 
            className="w-8 h-8 rounded-lg flex items-center justify-center"
            style={{ backgroundColor: '#FF6B35' }}
          >
            <User size={16} className="text-white" />
          </div>
          <span 
            className="font-bold text-lg"
            style={{ color: '#FF6B35' }}
          >
            RideShare
          </span>
        </div>
      </div>
      
      {/* Button Test */}
      <div className="mb-6">
        <button
          className="px-8 py-4 rounded-full font-bold text-lg text-black transition-all hover:-translate-y-1"
          style={{ 
            backgroundColor: '#FFD700',
            boxShadow: '0 4px 12px rgba(255, 215, 0, 0.3)'
          }}
        >
          <Power size={20} className="inline mr-2" />
          Conectar
        </button>
      </div>
      
      {/* Notification Test */}
      <div className="bg-black bg-opacity-80 text-white rounded-xl p-4 max-w-sm mb-6">
        <div className="flex items-start gap-3">
          <div 
            className="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5"
            style={{ backgroundColor: '#FF6B35' }}
          >
            <Search size={12} />
          </div>
          <div>
            <div className="font-semibold text-sm">Otimize para mais corridas</div>
            <div className="text-xs opacity-90 mt-1">Buscando corridas...</div>
          </div>
        </div>
      </div>
      
      {/* Gradient Test */}
      <div 
        className="text-white p-6 rounded-xl mb-6"
        style={{ background: 'linear-gradient(135deg, #FF6B35 0%, #FF8A65 100%)' }}
      >
        <h3 className="text-xl font-bold">Gradiente RideShare</h3>
        <p className="opacity-90">Teste do gradiente laranja</p>
      </div>
      
      {/* Color Palette */}
      <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
        <div 
          className="h-20 rounded-lg flex items-center justify-center text-white font-bold"
          style={{ backgroundColor: '#FF6B35' }}
        >
          #FF6B35
        </div>
        <div 
          className="h-20 rounded-lg flex items-center justify-center text-white font-bold"
          style={{ backgroundColor: '#E55A2B' }}
        >
          #E55A2B
        </div>
        <div 
          className="h-20 rounded-lg flex items-center justify-center text-white font-bold"
          style={{ backgroundColor: '#FF8A65' }}
        >
          #FF8A65
        </div>
        <div 
          className="h-20 rounded-lg flex items-center justify-center text-black font-bold"
          style={{ backgroundColor: '#FFD700' }}
        >
          #FFD700
        </div>
      </div>
    </div>
  );
};

export default ColorTest;