import React, { useState, useEffect } from 'react';
import LoginScreen from './components/LoginScreen';
import MainScreen from './components/MainScreen';

const DriverApp = () => {
  const [user, setUser] = useState(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    checkAuth();
  }, []);

  const checkAuth = () => {
    try {
      const savedUser = localStorage.getItem('rideshare_driver');
      const loginTime = localStorage.getItem('rideshare_driver_login_time');
      
      if (savedUser && loginTime) {
        const timeDiff = Date.now() - parseInt(loginTime);
        const oneDay = 24 * 60 * 60 * 1000;
        
        if (timeDiff < oneDay) {
          setUser(JSON.parse(savedUser));
        } else {
          logout();
        }
      }
    } catch (error) {
      console.error('Erro ao verificar auth:', error);
      logout();
    } finally {
      setLoading(false);
    }
  };

  const login = async (email, senha) => {
    try {
      const response = await fetch('/plataforma/api/auth.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ 
          action: 'login_motorista', 
          email, 
          senha 
        })
      });

      const data = await response.json();

      if (data.success) {
        const userData = data.motorista;
        setUser(userData);
        localStorage.setItem('rideshare_driver', JSON.stringify(userData));
        localStorage.setItem('rideshare_driver_login_time', Date.now().toString());
        return { success: true };
      } else {
        return { success: false, message: data.message };
      }
    } catch (error) {
      console.error('Erro no login:', error);
      return { success: false, message: 'Erro de conexão' };
    }
  };

  const logout = () => {
    setUser(null);
    localStorage.removeItem('rideshare_driver');
    localStorage.removeItem('rideshare_driver_login_time');
  };

  if (loading) {
    return (
      <div className="min-h-screen flex items-center justify-center bg-gray-100">
        <div className="text-center">
          <div className="w-12 h-12 border-4 border-orange-500 border-t-transparent rounded-full animate-spin mx-auto mb-4"></div>
          <p className="text-gray-600">Carregando...</p>
        </div>
      </div>
    );
  }

  if (!user) {
    return <LoginScreen onLogin={login} />;
  }

  return <MainScreen user={user} onLogout={logout} />;
};

export default DriverApp;