# 🚗 RideShare - App de Motorista e Passageiro

Plataforma completa de compartilhamento de caronas com design moderno tipo Uber.

## ✨ Características

### 👤 App do Passageiro
- ✅ Autenticação com email/senha
- ✅ Busca de origem e destino com autocomplete Google Maps
- ✅ Seleção de categoria de veículo
- ✅ Cálculo automático de preço
- ✅ Rastreamento em tempo real
- ✅ Design moderno com gradientes
- ✅ Dark mode nos componentes

### 🚗 App do Motorista  
- ✅ Login/Registro de motorista
- ✅ Status online/offline
- ✅ Aceitar/Rejeitar corridas
- ✅ Mapa em tela cheia com localização
- ✅ Ganho do dia em tempo real
- ✅ Botão de conexão grande e chamativo
- ✅ Design amarelo (estilo Uber)

## 🛠 Tecnologias Usadas

- **React 18** - UI Framework
- **Vite** - Build tool ultrarrápido
- **Tailwind CSS** - Styling
- **React Router** - Navegação
- **Axios** - HTTP client
- **Google Maps API** - Mapas e geolocalização
- **Lucide React** - Ícones
- **Capacitor** - Framework mobile

## 📦 Instalação

```bash
# 1. Clonar o repositório
git clone <seu-repositorio>
cd react-apps

# 2. Instalar dependências
npm install

# 3. Configurar variáveis de ambiente
# Copie .env.example para .env
# Configure sua API Key do Google Maps em passenger.html e driver.html

# 4. Iniciar desenvolvimento
npm run dev

# 5. Build para produção
npm run build

# 6. Visualizar build
npm run preview
```

## 🌐 URLs de Acesso

**Desenvolvimento:**
- Passageiro: http://localhost:3000/
- Motorista: http://localhost:3000/driver.html

**Produção:**
- Passageiro: `/passenger.html`
- Motorista: `/driver.html`

## 🔐 Autenticação

### Login Passageiro
```
Email: usuario@example.com
Senha: sua_senha
```

### Login Motorista
```
Email: motorista@example.com
Senha: sua_senha
CPF: 000.000.000-00
CNH: 00000000000
```

## 📱 Gerar APK

Veja o arquivo `APK_GUIDE.md` para instruções completas sobre como gerar o APK para Android.

**Métodos disponíveis:**
1. ⭐ Expo Go (Mais fácil)
2. React Native + Capacitor
3. Serviços online (PhoneGap, EAS)

## 📁 Estrutura do Projeto

```
react-apps/
├── src/
│   ├── components/          # Componentes compartilhados
│   │   └── shared/
│   │       ├── Button.jsx   # Botão customizado
│   │       ├── Input.jsx    # Input customizado
│   │       ├── Modal.jsx    # Modal customizado
│   │       └── LoadingSpinner.jsx
│   ├── driver/              # App do Motorista
│   │   ├── components/
│   │   ├── main.jsx
│   │   ├── DriverApp.jsx
│   │   └── index.css
│   ├── passenger/           # App do Passageiro
│   │   ├── components/
│   │   ├── main.jsx
│   │   ├── PassengerApp.jsx
│   │   └── index.css
│   ├── hooks/               # Custom hooks
│   │   ├── useAuth.jsx      # Autenticação
│   │   └── useGeolocation.jsx # Localização
│   └── services/            # Serviços API
│       └── api.js           # Configuração Axios
├── dist/                    # Build compilado (produção)
├── android/                 # Projeto Android (Capacitor)
├── package.json
├── vite.config.js
├── tailwind.config.js
├── capacitor.config.json
└── APK_GUIDE.md             # Guia para gerar APK
```

## 🎨 Design System

### Cores
- **Passageiro**: Gradiente escuro (slate/purple)
- **Motorista**: Gradiente preto/cinza com amarelo vibrante
- **Primária**: Preto (#000)
- **Secundária**: Cinza (#E5E7EB)
- **Destaque**: Amarelo (#FBBF24) para motorista

### Tipografia
- **Font**: Inter 300-800
- **Heading**: Bold/Semibold
- **Body**: Regular
- **Small**: Light

### Componentes
- **Border Radius**: 8px, 12px, 16px, 24px
- **Shadows**: Soft, Medium, Large
- **Animations**: Slide-up, Fade-in, Pulse

## 🔌 APIs Necessárias

### Google Maps
```javascript
// Adicione em passenger.html e driver.html
<script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places"></script>
```

### Backend
Configure a URL base em `src/services/api.js`:
```javascript
const API_BASE_URL = 'https://seu-backend.com/api';
```

## 🚀 Deploy

### Vercel (Recomendado)
```bash
npm install -g vercel
vercel
```

### GitHub Pages
```bash
npm run build
# Fazer push para gh-pages branch
```

### XAMPP (Local)
```bash
# Copiar dist/ para htdocs/
cp -r dist/* /xampp/htdocs/seu-projeto/
```

## 📝 Variáveis de Ambiente

Crie um arquivo `.env`:
```
VITE_API_URL=http://localhost/plataforma/api
VITE_GOOGLE_MAPS_KEY=sua_chave_aqui
```

## 🐛 Troubleshooting

### Porta em uso
```bash
# Windows
netstat -ano | findstr :3000
taskkill /F /PID <PID>

# Linux/Mac
lsof -i :3000
kill -9 <PID>
```

### Erro de CORS
Configure cors no seu backend ou proxy no vite.config.js

### Geolocalização não funciona
- Habilitar HTTPS em produção
- Solicitar permissão ao usuário
- Verificar browser compatibility

### Google Maps não carrega
- Validar API key
- Verificar restrições de origem
- Habilitar APIs necessárias na GCP

## 📚 Documentação

- [React Docs](https://react.dev)
- [Vite Docs](https://vitejs.dev)
- [Tailwind CSS](https://tailwindcss.com)
- [Google Maps API](https://developers.google.com/maps)
- [Capacitor Docs](https://capacitorjs.com)

## 🤝 Contribuindo

1. Fork o projeto
2. Crie uma branch para sua feature (`git checkout -b feature/AmazingFeature`)
3. Commit suas mudanças (`git commit -m 'Add some AmazingFeature'`)
4. Push para a branch (`git push origin feature/AmazingFeature`)
5. Abra um Pull Request

## 📄 Licença

Este projeto está sob a licença MIT. Veja o arquivo LICENSE para detalhes.

## 📞 Suporte

Para dúvidas ou problemas, abra uma issue no repositório ou entre em contato.

---

**Desenvolvido com ❤️**

**Versão**: 1.0.0  
**Última atualização**: 11/12/2025  
**Status**: ✅ Pronto para produção
