# 🚗 RideShare React Apps

Apps React modernos para a plataforma RideShare - Passageiro e Motorista.

## 🚀 Instalação e Execução

### 1. Instalar Dependências
```bash
cd react-apps
npm install
```

### 2. Executar em Desenvolvimento

#### App do Passageiro (Porta 3001)
```bash
npm run dev:passenger
```
Acesse: `http://localhost:3001/passenger.html`

#### App do Motorista (Porta 3002)
```bash
npm run dev:driver
```
Acesse: `http://localhost:3002/driver.html`

#### Ambos os Apps (Porta 3000)
```bash
npm run dev
```
- Passageiro: `http://localhost:3000/passenger.html`
- Motorista: `http://localhost:3000/driver.html`

### 3. Build para Produção
```bash
npm run build
```

## 📱 Funcionalidades

### App do Passageiro
- ✅ Login/Cadastro de usuários
- ✅ Geolocalização automática
- ✅ Autocomplete de endereços (Google Maps)
- ✅ Seleção de categoria de veículo
- ✅ Cálculo de preço em tempo real
- ✅ Solicitação de corridas
- ✅ Acompanhamento de corrida
- ✅ Cancelamento de corridas
- ✅ Sistema de avaliação
- ✅ Interface responsiva

### App do Motorista (Estilo 99pop)
- ✅ Login/Cadastro de motoristas
- ✅ Interface profissional estilo 99pop
- ✅ Status online/offline com estados "Conectar/Buscando"
- ✅ Recebimento de corridas com timer
- ✅ Aceitação/Rejeição de corridas
- ✅ Navegação GPS com marcador personalizado
- ✅ Hexágonos de surge pricing no mapa
- ✅ Alternância de tema escuro/claro do mapa
- ✅ Display de saldo no topo
- ✅ Menu lateral com perfil do motorista
- ✅ Controle de corrida (iniciar/finalizar)
- ✅ Dashboard de ganhos
- ✅ Histórico de corridas
- ✅ Notificações animadas e indicadores de status
- ✅ Interface responsiva

## 🛠️ Tecnologias Utilizadas

- **React 18** - Framework principal
- **Vite** - Build tool e dev server
- **React Router** - Roteamento
- **Axios** - Cliente HTTP
- **Tailwind CSS** - Estilização
- **Lucide React** - Ícones
- **Google Maps API** - Mapas e geolocalização

## 🔧 Configuração

### Google Maps API
A chave da API está configurada nos arquivos HTML:
```javascript
// Substitua pela sua chave se necessário
key=AIzaSyBQyClNByvKjHubTBizQ1GquLjhwSyHz2k
```

### Proxy da API
O Vite está configurado para fazer proxy das requisições para a API PHP:
```javascript
proxy: {
  '/plataforma/api': {
    target: 'http://localhost',
    changeOrigin: true,
    secure: false
  }
}
```

## 📂 Estrutura do Projeto

```
react-apps/
├── src/
│   ├── components/shared/     # Componentes reutilizáveis
│   ├── hooks/                 # Hooks personalizados
│   ├── services/              # Serviços de API
│   ├── passenger/             # App do Passageiro
│   │   ├── components/
│   │   ├── main.jsx
│   │   └── index.css
│   └── driver/                # App do Motorista
│       ├── components/
│       ├── main.jsx
│       └── index.css
├── passenger.html             # Entrada do app passageiro
├── driver.html               # Entrada do app motorista
├── package.json
└── vite.config.js
```

## 🔗 Integração com API

Os apps se conectam automaticamente com a API PHP existente:
- **Autenticação**: `/plataforma/api/auth.php`
- **Corridas**: `/plataforma/api/corridas.php`
- **Motoristas**: `/plataforma/api/motoristas.php`
- **Admin**: `/plataforma/api/admin.php`

## 📱 Como Testar

1. **Certifique-se** que o servidor PHP está rodando
2. **Execute** os apps React
3. **Teste o fluxo completo**:
   - Cadastro/Login
   - Solicitação de corrida (passageiro)
   - Aceitação de corrida (motorista)
   - Acompanhamento em tempo real
   - Finalização e avaliação

## 🎨 Personalização

### Cores e Tema
Edite as classes Tailwind nos componentes ou adicione CSS customizado nos arquivos `index.css`.

### Componentes
Todos os componentes estão em `src/components/shared/` e podem ser reutilizados.

### Hooks
- `useAuth` - Gerenciamento de autenticação
- `useGeolocation` - Geolocalização do usuário

## 🚀 Deploy

Para deploy em produção:

1. **Build** os apps:
   ```bash
   npm run build
   ```

2. **Copie** os arquivos da pasta `dist/` para seu servidor web

3. **Configure** o servidor para servir os arquivos estáticos

4. **Ajuste** as URLs da API se necessário

## 📞 Suporte

Para dúvidas ou problemas:
- Verifique os logs do console do navegador
- Confirme se a API PHP está funcionando
- Teste a conectividade com a internet (Google Maps)
- Verifique as permissões de geolocalização do navegador