# 🚀 Instalação Rápida - Apps React RideShare

## 📋 Pré-requisitos
- Node.js 16+ instalado
- Servidor PHP rodando (XAMPP, WAMP, etc.)
- API RideShare funcionando

## ⚡ Instalação em 3 Passos

### 1️⃣ Instalar Dependências
```bash
cd react-apps
npm install
```

### 2️⃣ Executar Apps
```bash
# App do Passageiro (porta 3001)
npm run dev:passenger

# App do Motorista (porta 3002) 
npm run dev:driver

# Ou ambos na porta 3000
npm run dev
```

### 3️⃣ Acessar Apps
- **Passageiro**: http://localhost:3001/passenger.html
- **Motorista**: http://localhost:3002/driver.html

## 🎯 Teste Rápido

1. **Abra ambos os apps** em abas diferentes
2. **Cadastre/Login** como passageiro e motorista
3. **Solicite uma corrida** no app passageiro
4. **Aceite a corrida** no app motorista
5. **Acompanhe o fluxo** completo

## 🔧 Problemas Comuns

### Erro de CORS
- Certifique-se que o servidor PHP está rodando
- Verifique se a API está em `http://localhost/plataforma/api`

### Google Maps não carrega
- Verifique a chave da API nos arquivos HTML
- Confirme conexão com internet

### Geolocalização não funciona
- Permita acesso à localização no navegador
- Use HTTPS em produção

## 📱 Funcionalidades Testadas

### ✅ App Passageiro
- Login/Cadastro
- Geolocalização automática
- Seleção de endereços
- Escolha de veículo
- Solicitação de corrida
- Acompanhamento em tempo real
- Cancelamento
- Avaliação

### ✅ App Motorista  
- Login/Cadastro
- Status online/offline
- Recebimento de corridas
- Aceitação/Rejeição
- Controle de corrida
- Dashboard de ganhos
- Localização em tempo real

## 🚀 Próximos Passos

Se tudo funcionou:
1. **Customize** as cores e layout
2. **Adicione** funcionalidades específicas
3. **Faça deploy** em produção
4. **Configure** notificações push
5. **Implemente** pagamentos online

## 📞 Suporte

Problemas? Verifique:
- Console do navegador (F12)
- Logs do servidor PHP
- Conectividade de rede
- Permissões do navegador