# 📱 Instruções para Gerar APK - RideShare Driver

## ✅ Status Atual
- ✅ Capacitor configurado
- ✅ Projeto Android criado
- ✅ Build de produção gerado
- ✅ Arquivos sincronizados

## 🔧 Requisitos para Gerar APK

### 1. Java 17 ou Superior
```bash
# Verificar versão atual
java -version

# Baixar Java 17 JDK:
# https://www.oracle.com/java/technologies/javase/jdk17-archive-downloads.html
```

### 2. Android SDK (Opcional - via Android Studio)
```bash
# Baixar Android Studio:
# https://developer.android.com/studio
```

## 🚀 Comandos para Gerar APK

### Opção 1: Com Android Studio
```bash
# Abrir projeto no Android Studio
npx cap open android

# No Android Studio:
# Build > Build Bundle(s) / APK(s) > Build APK(s)
```

### Opção 2: Via Linha de Comando (Requer Java 17)
```bash
# Navegar para pasta android
cd android

# Gerar APK debug
./gradlew assembleDebug

# Gerar APK release (assinado)
./gradlew assembleRelease
```

## 📁 Localização do APK Gerado
```
react-apps/android/app/build/outputs/apk/debug/app-debug.apk
```

## 🔧 Configurações do App

### Permissões Incluídas:
- ✅ Localização (GPS)
- ✅ Internet
- ✅ Notificações
- ✅ Vibração

### Configurações:
- **Nome:** RideShare Driver
- **Package:** com.rideshare.driver
- **Cores:** Laranja (#FF6B35)
- **Ícone:** Configurado automaticamente

## 🎯 Funcionalidades do APK
- ✅ Login de motorista
- ✅ Mapa com localização real
- ✅ Sistema de corridas reais
- ✅ Sons de notificação (Uber)
- ✅ Interface estilo 99pop
- ✅ Tela de ganhos completa
- ✅ PWA integrado
- ✅ Modo offline básico

## 🔄 Atualizações Futuras
Para atualizar o APK:
1. Fazer alterações no código
2. `npm run build`
3. `npx cap sync`
4. Gerar novo APK

## 📱 Instalação no Dispositivo
1. Ativar "Fontes desconhecidas" no Android
2. Transferir APK para o dispositivo
3. Instalar o arquivo APK
4. Conceder permissões de localização

## 🌐 URL de Produção
O app está configurado para acessar:
```
/plataforma/api/
```

Para produção, alterar em `src/services/api.js`:
```javascript
const API_BASE_URL = 'https://seudominio.com/api';
```

## 🔐 Assinatura para Play Store
Para publicar na Play Store, será necessário:
1. Gerar keystore
2. Configurar assinatura
3. Gerar APK release assinado
4. Upload na Play Console

---
**Status:** ✅ Pronto para gerar APK (requer Java 17)
**Última atualização:** ${new Date().toLocaleDateString('pt-BR')}