# 📱 Guia de Geração do APK - RideShare

## ✅ Arquivo Compilado Disponível

O projeto foi compilado com sucesso! Os arquivos estão em:
- **Pasta**: `dist/`
- **Zip**: `rideshare-app-build.zip` (89 KB)

## 📲 Como Gerar o APK (3 Opções)

### **Opção 1: Usar Expo (Mais Fácil)** ⭐ RECOMENDADO

```bash
# 1. Instalar Expo CLI
npm install -g expo-cli

# 2. Na raiz do projeto, instalar dependências
npm install

# 3. Iniciar Expo
npx expo start

# 4. Usar o app Expo Go no seu celular para testar
# 5. Para gerar APK, visite: https://expo.dev/
```

### **Opção 2: React Native + Capacitor**

```bash
# 1. Instalar Java JDK (necessário)
# https://www.oracle.com/java/technologies/downloads/

# 2. Instalar Android Studio
# https://developer.android.com/studio

# 3. Configurar variáveis de ambiente (ANDROID_HOME, etc)

# 4. Gerar APK
cd android
./gradlew assembleRelease
# O APK estará em: android/app/build/outputs/apk/release/
```

### **Opção 3: Usar Serviço Online (Mais Rápido)**

Envie o arquivo `rideshare-app-build.zip` para:

1. **Cordova Build** (Apache Cordova)
   - Acesse: https://build.phonegap.com/
   - Upload do `dist/` 
   - Selecione Android
   - Download do APK

2. **Expo Application Services**
   - Acesse: https://expo.dev/eas
   - Faça login
   - Upload do projeto
   - Build remoto

## 📦 Estrutura do Build

```
dist/
├── index.html          (Entrada principal)
├── passenger.html      (App do Passageiro)
├── driver.html         (App do Motorista)
├── assets/
│   ├── driver-*.js     (JavaScript do motorista)
│   ├── passenger-*.js  (JavaScript do passageiro)
│   ├── driver-*.css    (Estilos do motorista)
│   ├── passenger-*.css (Estilos do passageiro)
│   └── useGeolocation-*.js (Geolocalização)
```

## 🚀 Para Testar Localmente no Android

### Usando Expo Go (Método Mais Rápido)

1. Baixe o **Expo Go** na Play Store
2. Escaneie o QR code exibido ao rodar `npx expo start`
3. O app abrirá no seu celular em tempo real

### Usando Android Emulator

1. Abra Android Studio
2. Crie um emulador virtual
3. Execute `npm run dev`
4. O app aparecerá no emulador

## 🔧 Requisitos Mínimos

**Para Desktop (Desenvolvimento):**
- Node.js 14+
- npm ou yarn
- Git

**Para Mobile (APK):**
- Java JDK 11+ (se usar Gradle)
- Android SDK (se usar Android Studio)
- Mínimo 2GB RAM

## 📥 Como Instalar o APK no Celular

1. Transferir o APK para o celular
2. Abrir o arquivo no gerenciador de arquivos
3. Instalar o aplicativo
4. Conceder permissões (localização, câmera, etc)

## ⚙️ Variáveis de Ambiente Necessárias

Se for compilar localmente, configure:

```bash
# Windows (PowerShell)
$env:JAVA_HOME = "C:\Program Files\Java\jdk-11"
$env:ANDROID_HOME = "C:\Users\[seu-usuario]\AppData\Local\Android\sdk"

# Linux/Mac
export JAVA_HOME=/usr/libexec/java_home
export ANDROID_HOME=~/Library/Android/sdk
export PATH=$PATH:$ANDROID_HOME/tools:$ANDROID_HOME/platform-tools
```

## 📞 Suporte & Debug

### Verificar Node/npm
```bash
node --version
npm --version
```

### Limpar cache
```bash
npm cache clean --force
rm -rf node_modules dist
npm install
npm run build
```

### Ver logs do APK
```bash
adb logcat
```

---

**Status**: ✅ Build compilado e pronto!
**Última atualização**: 11/12/2025 03:54
**Versão**: 1.0.0
