<?php
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Diagnóstico Completo - RideShare</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .success { color: green; }
        .error { color: red; }
        .warning { color: orange; }
        .section { border: 1px solid #ddd; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .btn { padding: 10px 20px; background: #4CAF50; color: white; border: none; border-radius: 5px; cursor: pointer; margin: 5px; }
        .btn:hover { background: #45a049; }
    </style>
</head>
<body>
    <h1>Diagnóstico Completo - RideShare Platform</h1>
    
    <div class="section">
        <h2>1. Teste de Servidor PHP</h2>
        <?php
        echo "<p class='success'>✓ PHP está funcionando</p>";
        echo "<p>Versão do PHP: " . phpversion() . "</p>";
        echo "<p>Data/Hora: " . date('Y-m-d H:i:s') . "</p>";
        ?>
    </div>
    
    <div class="section">
        <h2>2. Teste de Conexão com Banco</h2>
        <?php
        try {
            require_once 'config/database.php';
            $db = new Database();
            $conn = $db->connect();
            echo "<p class='success'>✓ Conexão com banco estabelecida</p>";
            
            // Verificar tabelas
            $tables = ['administradores', 'usuarios', 'motoristas', 'corridas', 'categorias_veiculo'];
            foreach ($tables as $table) {
                $stmt = $conn->query("SHOW TABLES LIKE '$table'");
                if ($stmt->rowCount() > 0) {
                    echo "<p class='success'>✓ Tabela '$table' existe</p>";
                } else {
                    echo "<p class='error'>❌ Tabela '$table' não existe</p>";
                }
            }
            
        } catch (Exception $e) {
            echo "<p class='error'>❌ Erro de conexão: " . $e->getMessage() . "</p>";
        }
        ?>
    </div>
    
    <div class="section">
        <h2>3. Verificação do Admin</h2>
        <?php
        if (isset($conn)) {
            try {
                $stmt = $conn->prepare("SELECT * FROM administradores WHERE email = ?");
                $stmt->execute(['admin@rideshare.com']);
                $admin = $stmt->fetch();
                
                if ($admin) {
                    echo "<p class='success'>✓ Admin encontrado</p>";
                    echo "<ul>";
                    echo "<li>ID: " . $admin['id'] . "</li>";
                    echo "<li>Nome: " . $admin['nome'] . "</li>";
                    echo "<li>Email: " . $admin['email'] . "</li>";
                    echo "<li>Nível: " . $admin['nivel'] . "</li>";
                    echo "<li>Ativo: " . ($admin['ativo'] ? 'SIM' : 'NÃO') . "</li>";
                    echo "</ul>";
                    
                    // Testar senha
                    $senha_valida = password_verify('123456', $admin['senha']);
                    if ($senha_valida) {
                        echo "<p class='success'>✓ Senha '123456' está correta</p>";
                    } else {
                        echo "<p class='error'>❌ Senha '123456' não confere</p>";
                        echo "<p class='warning'>Corrigindo senha...</p>";
                        
                        $novo_hash = password_hash('123456', PASSWORD_BCRYPT);
                        $stmt = $conn->prepare("UPDATE administradores SET senha = ? WHERE email = ?");
                        if ($stmt->execute([$novo_hash, 'admin@rideshare.com'])) {
                            echo "<p class='success'>✓ Senha corrigida com sucesso!</p>";
                        } else {
                            echo "<p class='error'>❌ Erro ao corrigir senha</p>";
                        }
                    }
                    
                } else {
                    echo "<p class='error'>❌ Admin não encontrado</p>";
                    echo "<p class='warning'>Criando admin padrão...</p>";
                    
                    $hash = password_hash('123456', PASSWORD_BCRYPT);
                    $stmt = $conn->prepare("INSERT INTO administradores (nome, email, senha, nivel, ativo) VALUES (?, ?, ?, ?, ?)");
                    if ($stmt->execute(['Administrador', 'admin@rideshare.com', $hash, 'super', 1])) {
                        echo "<p class='success'>✓ Admin criado com sucesso!</p>";
                    } else {
                        echo "<p class='error'>❌ Erro ao criar admin</p>";
                    }
                }
                
            } catch (Exception $e) {
                echo "<p class='error'>❌ Erro: " . $e->getMessage() . "</p>";
            }
        }
        ?>
    </div>
    
    <div class="section">
        <h2>4. Teste da API de Login</h2>
        <button class="btn" onclick="testarLogin()">Testar Login</button>
        <div id="resultado-login"></div>
        
        <script>
        async function testarLogin() {
            const resultado = document.getElementById('resultado-login');
            resultado.innerHTML = '<p>Testando...</p>';
            
            try {
                const response = await fetch('api/auth.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                        action: 'login_admin',
                        email: 'admin@rideshare.com',
                        senha: '123456'
                    })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    resultado.innerHTML = '<p class="success">✓ Login funcionando! Redirecionando...</p>';
                    setTimeout(() => {
                        window.location.href = 'admin/index.html';
                    }, 2000);
                } else {
                    resultado.innerHTML = '<p class="error">❌ Erro no login: ' + data.message + '</p>';
                }
                
            } catch (error) {
                resultado.innerHTML = '<p class="error">❌ Erro na requisição: ' + error.message + '</p>';
            }
        }
        </script>
    </div>
    
    <div class="section">
        <h2>5. Links Úteis</h2>
        <p><a href="admin/index.html" target="_blank">Painel Administrativo</a></p>
        <p><a href="motorista/index.html" target="_blank">App Motorista</a></p>
        <p><a href="passageiro/index.html" target="_blank">App Passageiro</a></p>
        <p><a href="test_login.html" target="_blank">Teste de Login Detalhado</a></p>
    </div>
    
    <div class="section">
        <h2>Credenciais de Acesso</h2>
        <p><strong>Email:</strong> admin@rideshare.com</p>
        <p><strong>Senha:</strong> 123456</p>
    </div>
</body>
</html>