<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/functions.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Registro de Usuário
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'register_usuario') {
    $nome = $input['nome'] ?? '';
    $email = $input['email'] ?? '';
    $telefone = $input['telefone'] ?? '';
    $senha = $input['senha'] ?? '';
    $cpf = $input['cpf'] ?? '';
    
    if (empty($nome) || empty($email) || empty($telefone) || empty($senha)) {
        jsonResponse(['success' => false, 'message' => 'Preencha todos os campos obrigatórios'], 400);
    }
    
    if (!validarEmail($email)) {
        jsonResponse(['success' => false, 'message' => 'Email inválido'], 400);
    }
    
    if (!empty($cpf) && !validarCPF($cpf)) {
        jsonResponse(['success' => false, 'message' => 'CPF inválido'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT id FROM usuarios WHERE email = ?");
        $stmt->execute([$email]);
        if ($stmt->fetch()) {
            jsonResponse(['success' => false, 'message' => 'Email já cadastrado'], 400);
        }
        
        $senha_hash = hashPassword($senha);
        
        $stmt = $conn->prepare("
            INSERT INTO usuarios (nome, email, telefone, senha, cpf)
            VALUES (?, ?, ?, ?, ?)
        ");
        
        $stmt->execute([$nome, $email, $telefone, $senha_hash, $cpf]);
        $usuario_id = $conn->lastInsertId();
        
        registrarLog('usuario', $usuario_id, 'registro', 'Novo usuário registrado');
        
        jsonResponse([
            'success' => true,
            'message' => 'Usuário registrado com sucesso',
            'usuario_id' => $usuario_id
        ]);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao registrar usuário'], 500);
    }
}

// Login de Usuário
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'login_usuario') {
    $email = $input['email'] ?? '';
    $senha = $input['senha'] ?? '';
    
    if (empty($email) || empty($senha)) {
        jsonResponse(['success' => false, 'message' => 'Email e senha são obrigatórios'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT * FROM usuarios WHERE email = ?");
        $stmt->execute([$email]);
        $usuario = $stmt->fetch();
        
        if (!$usuario || !verifyPassword($senha, $usuario['senha'])) {
            jsonResponse(['success' => false, 'message' => 'Email ou senha incorretos'], 401);
        }
        
        if ($usuario['status'] === 'bloqueado') {
            jsonResponse(['success' => false, 'message' => 'Usuário bloqueado'], 403);
        }
        
        $token = generateToken();
        
        registrarLog('usuario', $usuario['id'], 'login', 'Login realizado');
        
        unset($usuario['senha']);
        
        jsonResponse([
            'success' => true,
            'message' => 'Login realizado com sucesso',
            'token' => $token,
            'usuario' => $usuario
        ]);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao fazer login'], 500);
    }
}

// Registro de Motorista
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'register_motorista') {
    $nome = $input['nome'] ?? '';
    $email = $input['email'] ?? '';
    $telefone = $input['telefone'] ?? '';
    $senha = $input['senha'] ?? '';
    $cpf = $input['cpf'] ?? '';
    $cnh = $input['cnh'] ?? '';
    $data_nascimento = $input['data_nascimento'] ?? '';
    $categoria_veiculo_id = $input['categoria_veiculo_id'] ?? '';
    $placa_veiculo = $input['placa_veiculo'] ?? '';
    $modelo_veiculo = $input['modelo_veiculo'] ?? '';
    $cor_veiculo = $input['cor_veiculo'] ?? '';
    $ano_veiculo = $input['ano_veiculo'] ?? '';
    
    if (empty($nome) || empty($email) || empty($telefone) || empty($senha) || 
        empty($cpf) || empty($cnh) || empty($categoria_veiculo_id)) {
        jsonResponse(['success' => false, 'message' => 'Preencha todos os campos obrigatórios'], 400);
    }
    
    if (!validarEmail($email)) {
        jsonResponse(['success' => false, 'message' => 'Email inválido'], 400);
    }
    
    if (!validarCPF($cpf)) {
        jsonResponse(['success' => false, 'message' => 'CPF inválido'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT id FROM motoristas WHERE email = ? OR cpf = ? OR cnh = ?");
        $stmt->execute([$email, $cpf, $cnh]);
        if ($stmt->fetch()) {
            jsonResponse(['success' => false, 'message' => 'Email, CPF ou CNH já cadastrados'], 400);
        }
        
        $senha_hash = hashPassword($senha);
        
        $stmt = $conn->prepare("
            INSERT INTO motoristas (nome, email, telefone, senha, cpf, cnh, data_nascimento,
                                   categoria_veiculo_id, placa_veiculo, modelo_veiculo, 
                                   cor_veiculo, ano_veiculo, status)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pendente')
        ");
        
        $stmt->execute([
            $nome, $email, $telefone, $senha_hash, $cpf, $cnh, $data_nascimento,
            $categoria_veiculo_id, $placa_veiculo, $modelo_veiculo, $cor_veiculo, $ano_veiculo
        ]);
        
        $motorista_id = $conn->lastInsertId();
        
        registrarLog('motorista', $motorista_id, 'registro', 'Novo motorista registrado - aguardando aprovação');
        
        jsonResponse([
            'success' => true,
            'message' => 'Cadastro enviado! Aguarde aprovação do administrador',
            'motorista_id' => $motorista_id
        ]);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao registrar motorista'], 500);
    }
}

// Login de Motorista
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'login_motorista') {
    $email = $input['email'] ?? '';
    $senha = $input['senha'] ?? '';
    
    if (empty($email) || empty($senha)) {
        jsonResponse(['success' => false, 'message' => 'Email e senha são obrigatórios'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT * FROM motoristas WHERE email = ?");
        $stmt->execute([$email]);
        $motorista = $stmt->fetch();
        
        if (!$motorista || !verifyPassword($senha, $motorista['senha'])) {
            jsonResponse(['success' => false, 'message' => 'Email ou senha incorretos'], 401);
        }
        
        if ($motorista['status'] === 'bloqueado') {
            jsonResponse(['success' => false, 'message' => 'Motorista bloqueado'], 403);
        }
        
        if ($motorista['status'] === 'pendente') {
            jsonResponse(['success' => false, 'message' => 'Cadastro aguardando aprovação'], 403);
        }
        
        $token = generateToken();
        
        registrarLog('motorista', $motorista['id'], 'login', 'Login realizado');
        
        unset($motorista['senha']);
        
        jsonResponse([
            'success' => true,
            'message' => 'Login realizado com sucesso',
            'token' => $token,
            'motorista' => $motorista
        ]);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao fazer login'], 500);
    }
}

// Login de Admin
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'login_admin') {
    $email = $input['email'] ?? '';
    $senha = $input['senha'] ?? '';
    
    if (empty($email) || empty($senha)) {
        jsonResponse(['success' => false, 'message' => 'Email e senha são obrigatórios'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT * FROM administradores WHERE email = ? AND ativo = TRUE");
        $stmt->execute([$email]);
        $admin = $stmt->fetch();
        
        if (!$admin || !verifyPassword($senha, $admin['senha'])) {
            jsonResponse(['success' => false, 'message' => 'Email ou senha incorretos'], 401);
        }
        
        $token = generateToken();
        
        registrarLog('admin', $admin['id'], 'login', 'Login realizado');
        
        unset($admin['senha']);
        
        jsonResponse([
            'success' => true,
            'message' => 'Login realizado com sucesso',
            'token' => $token,
            'admin' => $admin
        ]);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao fazer login'], 500);
    }
}

// Verificar se usuário ainda é válido
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'verificar_usuario') {
    $user_id = $input['user_id'] ?? '';
    
    if (empty($user_id)) {
        jsonResponse(['success' => false, 'message' => 'ID do usuário é obrigatório'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT id, ativo FROM usuarios WHERE id = ?");
        $stmt->execute([$user_id]);
        $usuario = $stmt->fetch();
        
        if ($usuario && $usuario['ativo']) {
            jsonResponse([
                'success' => true,
                'usuario_ativo' => true
            ]);
        } else {
            jsonResponse([
                'success' => false,
                'usuario_ativo' => false,
                'message' => 'Usuário não encontrado ou inativo'
            ]);
        }
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao verificar usuário'], 500);
    }
}

jsonResponse(['success' => false, 'message' => 'Ação inválida'], 400);
