# 🚗 RideShare Platform

Sistema completo de transporte de passageiros e entregas com interface moderna e funcionalidades avançadas.

## ✨ Funcionalidades

- 👥 **App Passageiro** - Solicitar corridas e entregas
- 🚗 **App Motorista** - Aceitar corridas e gerenciar ganhos  
- 🔐 **Painel Administrativo** - Gerenciar toda a plataforma
- 💰 **Sistema de Pagamentos** - Múltiplas formas de pagamento
- 🗺️ **Mapas em Tempo Real** - Rastreamento GPS integrado
- 📊 **Tarifa Dinâmica** - Preços baseados em demanda
- 🏷️ **Múltiplas Categorias** - Carros, motos, entregas

## 🚀 Como Acessar

### 1. Página Principal
```
http://localhost/plataforma/
```

### 2. Login Administrativo
```
http://localhost/plataforma/login.html
```
**Credenciais:**
- Email: `admin@rideshare.com`
- Senha: `123456`

### 3. Dashboard Admin
```
http://localhost/plataforma/admin/dashboard.html
```

### 4. Apps dos Usuários
- **Passageiro:** `http://localhost/plataforma/passageiro/`
- **Motorista:** `http://localhost/plataforma/motorista/`

## 📁 Estrutura do Projeto

```
plataforma/
├── index.html              # Página inicial
├── login.html              # Tela de login moderna
├── admin/
│   ├── dashboard.html       # Dashboard principal
│   └── index.html          # Painel completo (pós-login)
├── motorista/              # App do motorista
├── passageiro/             # App do passageiro
├── api/                    # API REST
├── config/                 # Configurações
├── database/               # Scripts SQL
└── includes/               # Funções auxiliares
```

## ⚙️ Requisitos

- **PHP:** 7.4+
- **MySQL:** 5.7+
- **Servidor:** Apache/Nginx
- **Navegador:** Moderno com suporte a ES6+

## 🔧 Instalação

1. **Clone/Baixe** o projeto para sua pasta do servidor web
2. **Configure** o banco de dados executando `database/schema.sql`
3. **Ajuste** as credenciais em `config/database.php`
4. **Acesse** `http://localhost/plataforma/`

## 🧪 Ferramentas de Teste

- `diagnostico_completo.php` - Verificação completa do sistema
- `test_login_errors.html` - Teste de diferentes cenários de login
- `update_admin_password.php` - Atualizar senha do admin

## 🎨 Características da Interface

- ✨ **Design Moderno** - Interface limpa e responsiva
- 🎭 **Animações Suaves** - Transições e efeitos visuais
- 📱 **Mobile-First** - Otimizado para dispositivos móveis
- 🔄 **Feedback Visual** - Loading, sucesso e erro animados
- 🌈 **Gradientes** - Visual moderno e atrativo
